//
// (c) 2023 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import "private"

UiTextEditBase {
    id : uiLineEdit

    horizontalMargin : 0
    verticalMargin   : 4

    children : UiBorder {
        id : border

        anchors.fill : parent
        anchors.leftMargin : -6
        anchors.rightMargin : -6

        color : {
            if (uiLineEdit.readOnly) {
                return UiColors.getColor(UiColors.White);
            }

            if (uiLineEdit.activeFocus) {
                return UiColors.getColor(UiColors.SelectionGreen);
            } else if (uiLineEdit.hover) {
                return UiColors.getColor(UiColors.HoverGreen);
            }

            return UiColors.getColor(UiColors.White);
        }
        borderWidth : 1
        style : UiBorder.Solid
        z : 100
        opacity : uiLineEdit.activeFocus || uiLineEdit.hover ? 1 : 0
    }
}
